definition module iTaskLogin

// (c) mjp 2007-2008 

import StdEnv, StdiTasks, loginAdmin

derive gForm  Account
derive gUpd   Account
derive gParse Account
derive gPrint Account
derive gerda  Account
derive read   Account
derive write  Account


// *********************************************************************************************************************************
/* Adminstrate and handle login procedures; change it if you don't like it
					
// loginProcedure will handle a login, and creates a new user account if necessary.
// Existing account information can be updated during login handling.
		Task Void:  is used to display a welcome messages to the user;
		Then a login procedure is offered: the user is asked for name and password...
		Alternatively, a new login can be added. In that case additional Account information can be asked and will be stored as well.
		When the login was succesful, the user id and her account information are yielded, the boolean indicates whether we have a new user.
		The login information is yielded as result. 
*/
	
loginProcedure 		:: !(Task Void) !(acc -> Task acc) -> (Task ((Bool,UserId),Account acc)) | iData acc

// *********************************************************************************************************************************
/* Read out account information
					
readAccountsDB 	:: account information of all users
readAccountDB 	:: account information of indicated user
*/

readAccountsDB 		:: (Task (Accounts a)) | iData a
readAccountDB 		:: !UserId -> Task (Maybe (Account a)) | iData a
